/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LongCode;
import net.sourceforge.plantuml.cucadiagram.entity.EntityImpl;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class EntityFactory {
    private final Map<Code, ILeaf> leafs = new Protect(new LinkedHashMap());
    private final List<Link> links = new ArrayList<Link>();
    private final Map<Code, IGroup> groups = new Protect(new LinkedHashMap());
    private int rawLayout;
    private final IGroup rootGroup = new GroupRoot(this);
    private final Set<LeafType> hiddenTypes;

    public EntityFactory(Set<LeafType> hiddenTypes) {
        this.hiddenTypes = hiddenTypes;
    }

    public boolean isHidden(LeafType leafType) {
        return this.hiddenTypes.contains((Object)leafType);
    }

    public ILeaf createLeaf(Code code, Display display, LeafType entityType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        if (entityType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(entityType, hides);
        LongCode longCode = this.getLongCode(code, namespaceSeparator);
        EntityImpl result = new EntityImpl(this, code, bodier, parentContainer, entityType, longCode, namespaceSeparator, this.rawLayout);
        result.setDisplay(display);
        return result;
    }

    private LongCode getLongCode(Code code, String namespaceSeparator) {
        LongCode result = LongCode.of(code.getFullName(), namespaceSeparator);
        return result;
    }

    public IGroup createGroup(Code code, Display display, Code namespace2, GroupType groupType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        if (groupType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(null, hides);
        LongCode longCode = this.getLongCode(code, namespaceSeparator);
        EntityImpl result = new EntityImpl(this, code, bodier, parentContainer, groupType, namespace2, longCode, namespaceSeparator, this.rawLayout);
        if (!Display.isNull(display)) {
            result.setDisplay(display);
        }
        return result;
    }

    public IGroup getRootGroup() {
        return this.rootGroup;
    }

    public final Map<Code, ILeaf> getLeafs() {
        return Collections.unmodifiableMap(this.leafs);
    }

    public void addLeaf(ILeaf entity) {
        this.leafs.put(entity.getCode(), entity);
    }

    public void incRawLayout() {
        ++this.rawLayout;
    }

    void removeLeaf(Code code) {
        IEntity removed = this.leafs.remove(code);
        if (removed == null) {
            throw new IllegalArgumentException();
        }
    }

    public void addGroup(IGroup group) {
        this.groups.put(group.getCode(), group);
    }

    void removeGroup(Code code) {
        IEntity removed = this.groups.remove(code);
        if (removed == null) {
            throw new IllegalArgumentException();
        }
    }

    public final Map<Code, IGroup> getGroups() {
        return Collections.unmodifiableMap(this.groups);
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void removeLink(Link link) {
        boolean ok = this.links.remove(link);
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    public IGroup muteToGroup(Code code, Code namespace2, GroupType type, IGroup parent) {
        ILeaf leaf = this.getLeafs().get(code);
        ((EntityImpl)leaf).muteToGroup(namespace2, type, parent);
        IGroup result = (IGroup)((Object)leaf);
        this.removeLeaf(code);
        return result;
    }

    static class Protect<O>
    implements Map<Code, O> {
        private final Map<Code, O> m;

        public Protect(Map<Code, O> data) {
            this.m = data;
        }

        @Override
        public O remove(Object key) {
            if (!(key instanceof Code)) {
                throw new IllegalArgumentException();
            }
            return this.m.remove(key);
        }

        @Override
        public O get(Object key) {
            if (!(key instanceof Code)) {
                throw new IllegalArgumentException();
            }
            return this.m.get(key);
        }

        @Override
        public Set<Code> keySet() {
            return this.m.keySet();
        }

        @Override
        public void putAll(Map<? extends Code, ? extends O> m) {
            this.m.putAll(m);
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof Code)) {
                throw new IllegalArgumentException();
            }
            return this.m.containsKey(key);
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public O put(Code key, O value) {
            if (!(key instanceof Code)) {
                throw new IllegalArgumentException();
            }
            return this.m.put(key, value);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Code, O>> entrySet() {
            return this.m.entrySet();
        }

        @Override
        public Collection<O> values() {
            return this.m.values();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }
    }
}

